/* Tag file for calling automatic code documenter autodox2.p.

autodox.p   2001 by Judy Hoffman Green, Joanju Limited

INPUT fileList
      Name of a file containing a list of program names
      (.w, .p, etc). One program name per line. Lines can
      be commented out by inserting lines containing nothing 
      but open comment (/*) and closing comment (*/).
*/

DEFINE INPUT PARAMETER fileList AS CHARACTER NO-UNDO.

DEFINE VARIABLE autodox AS HANDLE NO-UNDO.

DEFINE VARIABLE appName AS CHARACTER              NO-UNDO.
DEFINE VARIABLE outDir  AS CHARACTER INITIAL "./" NO-UNDO.

REPEAT: 
  RUN autodox/textprompt2.w
    (INPUT "Enter the name of the directory for the "
           + "output HTML files. File names in the file list should be "
           + "absolute. "
           + "Enter ./ for current (working) directory.",
     INPUT-OUTPUT outDir,
     INPUT "~n~n~n Enter your application's name.~n",
     INPUT-OUTPUT appName
    ).
  IF RETURN-VALUE = "cancel" THEN
     RETURN.

  IF LENGTH(outDir) > 0 
  AND SUBSTRING(outDir,LENGTH(outDir),1) <> "/"
  AND SUBSTRING(outDir,LENGTH(outDir),1) <> "~\"
  THEN DO: 
    MESSAGE "Please re-enter output directory name with a / or \ at the end." VIEW-AS ALERT-BOX. 
    UNDO, RETRY.
  END. 
  ELSE LEAVE.
END. 


RUN autodox/autodox2.p PERSISTENT SET autodox.

RUN setFileList IN autodox (fileList).
RUN setOutputDir IN autodox (outDir).
RUN setAppName IN autodox (appName).

RUN setProcCommentLoc IN autodox (FALSE).    /* TRUE = Before, FALSE = After. See readme.html */
RUN setFuncCommentLoc IN autodox (FALSE).    /* TRUE = Before, FALSE = After. See readme.html */
RUN setParamCommentLoc IN autodox (FALSE).   /* TRUE = Before, FALSE = After. See readme.html */

RUN main IN autodox.

MESSAGE "Open" outDir + "index.html to view the generated documentation." VIEW-AS ALERT-BOX.

APPLY "CLOSE":U TO autodox.


